
//////////////////////////////////////////////////
//						//
// XCD -- Extended Change Directory		//
//						//
// Written by Mike Granby <mikeg@paracon.co.uk> //
//						//
// NO WARRANTY. PLEASE DISTRIBUTE FREELY.	//
//						//
//////////////////////////////////////////////////

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//////////////////////////////////////////////////
//
// Static Data
//

static	char	sResult[MAX_PATH] = { 0 };

//////////////////////////////////////////////////
//
// Prototypes
//

void	main(int nArg, PCSTR pArg[]);
void	Error(PCSTR pText, ...);
BOOL	ParsePath(PCSTR pText);
BOOL	ParseSpec(PCSTR pText);
void	AddSeg(PCSTR pText, UINT uSize);
void	MakeBatchFile(void);

//////////////////////////////////////////////////
//
// Code
//

void	main(int nArg, PCSTR pArg[])
{
	if( nArg == 2 ) {

		if( ParsePath(pArg[1]) && SetCurrentDirectory(sResult) ) {

			MakeBatchFile();
			
			exit(0);
			}
		
		Error("no such directory\n");
		}

	printf("usage: xcd <ambiguous path>\n");
	
	exit(1);
	}

void	Error(PCSTR pText, ...)
{
	printf("xcd: ");
	
	vprintf(pText, (PSTR) (&pText + 1));
	
	exit(2);
	}

BOOL	ParsePath(PCSTR pText)
{
	if( pText[1] == ':' ) {
	
		AddSeg(pText, 2);
		
		pText += 2;
		}
		
	if( pText[0] == '\\' ) {
	
		AddSeg(pText, 1);
		
		pText += 1;
		}
	
	while( pText[0] ) {
	
		char sPath[MAX_PATH];
		
		strcpy(sPath, sResult);
		
		PSTR pSrc = sPath + strlen(sPath);
		
		strcat(sPath, pText);
		
		PSTR pEnd = strchr(pSrc, '\\');
		
		if( pEnd )
			*pEnd = 0;
	
		if( !ParseSpec(sPath) )
			return FALSE;
		
		if( pEnd ) {
		
			AddSeg("\\", 1);
			
			pText += 1 + pEnd - pSrc;
			}
		else
			break;
		}
		
	return TRUE;
	}

BOOL	ParseSpec(PCSTR pText)
{
	UINT uScan = strlen(pText) - 1;
	
	for(;;) {
	
		if( pText[uScan] == '\\' ) {
		
			AddSeg(pText + uScan + 1, 0);

			return TRUE;
			}

		if( pText[uScan] != '.' )
			break;
			
		uScan--;
		}
	
	WIN32_FIND_DATA Data;

	HANDLE hFind = FindFirstFile(pText, &Data);
	
	while( hFind ) {
	
		if( Data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) {

			AddSeg(Data.cFileName, 0);
			
			FindClose(hFind);
			
			return TRUE;
			}
		
		if( !FindNextFile(hFind, &Data) ) {
		
			FindClose(hFind);
			
			return FALSE;
			}
		}
	
	return FALSE;
	}

void	AddSeg(PCSTR pText, UINT uSize)
{
	if( uSize ) {
	
		UINT uLen = strlen(sResult);
		
		strncpy(sResult + uLen, pText, uSize);
		
		sResult[uLen + uSize] = 0;
		}
	else
		strcat(sResult, pText);
	}

void	MakeBatchFile(void)
{
	char sName[MAX_PATH];
	
	GetEnvironmentVariable("TEMP", sName, MAX_PATH);
	
	strcat(sName, "\\xcd2.bat");

	FILE *pFile = fopen(sName, "wa");
	
	if( pFile ) {
	
		if( sResult[1] == ':' ) {
		
			fprintf(pFile, "%c:\n", sResult[0]);
	
			fprintf(pFile, "chdir \"%s\"\n", sResult + 2);
			}
		else
			fprintf(pFile, "chdir \"%s\"\n", sResult);
	
		fclose(pFile);
		}
	}

// End of File
